/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.prof;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import com.ibm.hsc.objmgr.prof.OmProfUpdater;
import com.ibm.hsc.objmgr.sysprof.OmSysProfMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class OmProfMgr {
    private OmLparMgr mLparMgr;
    private RObject mLparObj;
    private RObjectId mProfOid;
    private RObject mProfObj;
    private OmProfUpdater mProfUpdater;
    private String mSettingID;

    private OmProfMgr(OmLparMgr omLparMgr, String string) throws RException {
        this.mLparMgr = omLparMgr;
        this.mSettingID = string;
        this.mProfOid = new RObjectId(1, R50Define.CID_IBMHSC_LparProfile);
        this.mProfOid.setKeyValue(0, "IBMHSC_Partition");
        this.mProfOid.setKeyValue(1, this.mLparMgr.getLparName());
        this.mProfOid.setKeyValue(2, this.mSettingID);
        this.mProfObj = this.mProfOid.getObject();
        if (this.mProfObj == null) {
            System.out.println("new profile: " + this.mProfOid);
            this.mProfObj = new RObject(this.mProfOid);
            this.mProfObj.addInstance();
        }
        this.mLparObj = this.mLparMgr.getObject();
        if (!this.mLparObj.hasAssociation(R50Define.AID_IBMHSC_PartitionProfile, this.mProfOid)) {
            System.out.println("add profile: " + this.mSettingID + " to partition: " + this.mLparMgr.getLparName());
            this.mLparObj.addAsso(R50Define.AID_IBMHSC_PartitionProfile, this.mProfOid);
        }
    }

    public static OmProfMgr getProfMgr(OmLparMgr omLparMgr, String string) throws RException {
        OmProfMgr omProfMgr = new OmProfMgr(omLparMgr, string);
        return omProfMgr;
    }

    public RObjectId getObjectId() {
        return this.mProfOid;
    }

    public RObject getObject() {
        return this.mProfObj;
    }

    public String getSettingID() {
        return this.mSettingID;
    }

    public OmLparMgr getLparMgr() {
        return this.mLparMgr;
    }

    public boolean updateProf(Hashtable hashtable) throws RException {
        if (this.mProfUpdater == null) {
            this.mProfUpdater = new OmProfUpdater(this);
        }
        return this.mProfUpdater.update(hashtable);
    }

    public void deleteProf(boolean bl) throws PIHscServerException {
        try {
            Object object;
            if (bl) {
                object = this.mLparMgr.getCecMgr().getSaveArea();
                ((PIHMCSaveArea)object).removeLPARProfile(Integer.parseInt(this.mSettingID));
            }
            object = this.mProfObj.associators(R50Define.AID_IBMHSC_InSysProfile);
            this.mProfObj.deleteInstance();
            if (object != null) {
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    PIHMCSaveArea pIHMCSaveArea;
                    RObject rObject = (RObject)iterator.next();
                    String string = (String)rObject.getProperty("Name");
                    Vector vector = rObject.associators(R50Define.AID_IBMHSC_InSysProfile);
                    if (vector == null || vector.size() == 0) {
                        rObject.deleteInstance();
                        this.mLparMgr.getCecMgr().getIndMgr().sendIndication(2, rObject, null);
                        if (bl) {
                            pIHMCSaveArea = this.mLparMgr.getCecMgr().getSaveArea();
                            pIHMCSaveArea.removeSysProfile(Integer.parseInt(string));
                            continue;
                        }
                    }
                    if (!bl) continue;
                    pIHMCSaveArea = this.mLparMgr.getCecMgr().getSaveArea();
                    pIHMCSaveArea.deleteLparProfileFromSysProfile(Integer.parseInt(string), Integer.parseInt(this.mSettingID));
                    Hashtable hashtable = pIHMCSaveArea.getSysProfile(Integer.parseInt(string));
                    OmSysProfMgr omSysProfMgr = OmSysProfMgr.createSysProfMgr(this.mLparMgr.getCecMgr(), string);
                    omSysProfMgr.updateSysProf(hashtable);
                }
            }
            this.mLparMgr.getCecMgr().getIndMgr().sendIndication(2, this.mProfObj, null);
        }
        catch (RException rException) {
            rException.printStackTrace();
            String[] stringArray = new String[]{this.mLparMgr.getLparName()};
            throw new PIHscServerException("05EC", stringArray, rException);
        }
    }
}

